/**
 * @author	Sven Kutzner
 * @copyright	2010 deixu.net
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 */
function TeamSpeakPermissions(data, suggestion) {
	this.name = 'permission';
	this.data = data;
	this.suggestion = suggestion;
	this.button = null;
	this.input = null;
	this.list = null;
	this.inputOldKeyUp;
	this.inputOldFocus;
	this.inputOldBlur;
	this.formOldSubmit;
	this.form;
	this.options = ['canView','canViewInformation','canViewBanner','canViewDataTransfer','canLogin'];
	
	this.selectedIndex = -1;
	
	this.inputHasFocus = false;
	
	this.buttonClick = function(event) {
		this.addItem();
	}
	
	this.inputFocus = function(event) {
		var result = true;
		if(this.inputOldFocus != undefined) result = this.inputOldFocus(event);
		this.inputHasFocus = true;
	}
	
	this.inputBlur = function(event) {
		var result = true;
		if(this.inputOldBlur != undefined) result = this.inputOldBlur(event);
		this.inputHasFocus = false;		
	}
	
	this.inputKeyUp = function(event) {
		var result = this.inputOldKeyUp(event);
		if (!event) event = window.event;
		
		// get key code
		var keyCode = 0;
		if (event.which) keyCode = event.which;
		else if (event.keyCode) keyCode = event.keyCode;

		// return
		if (keyCode == 13 && result) {
			this.addItem();
		}
	}
	
	this.optionClick = function(event, option, type) {
		if(type == 'yes') {
			document.getElementById(option+'No').checked = false;
			if(this.selectedIndex != -1) {
				this.data[this.selectedIndex][option] = 1;
			}
		} else if(type == 'no') {
			document.getElementById(option+'Yes').checked = false;
			if(this.selectedIndex != -1) {
				this.data[this.selectedIndex][option] = 0;
			}
		} else {
			if(this.selectedIndex != -1) {
				this.data[this.selectedIndex][option] = -1;
			}
		}
	}
	
	this.whiteListClick = function(event) {
		var whiteList = this.getWhiteList();
		if(this.selectedIndex != -1) {
			this.data[this.selectedIndex]['whiteList'] = whiteList;
		}
	}
	
	this.init = function() {
		this.button = document.getElementById(this.name+'AddButton');
		Event.observe(this.button, 'click', this.buttonClick.bindAsEventListener(this));
		this.input = document.getElementById(this.name+'AddInput');
		this.inputOldKeyUp = this.input.onkeyup;
		this.inputOldFocus = this.input.onfocus;
		this.inputOldBlur = this.input.onblur;
		Event.observe(this.input, 'focus', this.inputFocus.bindAsEventListener(this));
		Event.observe(this.input, 'blur', this.inputBlur.bindAsEventListener(this));
		Event.observe(this.input, 'keyup', this.inputKeyUp.bindAsEventListener(this));
		this.list = document.getElementById(this.name+'List');
		this.form = document.getElementById(this.name+'Form');
		this.formOldSubmit = this.form.onsubmit;
		for(var i=0;i<this.options.length;i++) {
			Event.observe(this.options[i]+'Yes', 'click', this.optionClick.bindAsEventListener(this, this.options[i], 'yes'))
			Event.observe(this.options[i]+'No', 'click', this.optionClick.bindAsEventListener(this, this.options[i], 'no'))
		}
		Event.observe('whiteList', 'click', this.whiteListClick.bindAsEventListener(this))
		Event.observe(this.form, 'submit', this.submit.bindAsEventListener(this));
		this.refreshList();
	}
	
	this.addItem = function() {
		var query = this.input.value;
		var uri = 'index.php?page=TeamSpeakUserGroupSuggest'+SID_ARG_2ND;
		var obj = this;
		new Ajax.Request(uri, {
			method: 'post',
			parameters: 'query='+encodeURIComponent(query),
			onSuccess: function(response) {
				obj.handleResponse(response);
			}
		});
	}
	
	this.handleResponse = function(response) {
		var xml = response.responseXML.childNodes[0];
		var query = xml.getAttribute('query');
		if(xml.childNodes.length == 0) return;
		var node = null;
		var name = '';
		var id = 0;
		var type = '';
		var firstNewKey = -1;
		for(var i=0;i<xml.childNodes.length;i++) {
			node = xml.childNodes[i];
			type = node.tagName;
			id = node.getAttribute('id');
			name = node.firstChild.nodeValue;
			doBreak = false;
			for(var j=0;j<this.data.length;j++) {
				if(this.data[j]['type'] == type && this.data[j]['id'] == id) doBreak = true;
			}
			
			var key = this.data.length;
			if(firstNewKey == -1) firstNewKey = key;
			var newObject = {'type':type, 'id':id, 'name':name, 'canView':-1, 'canViewInformation':-1, 'canViewBanner':-1, 'canViewDataTransfer':-1, 'canLogin':-1, 'whiteList':[-1]};
			this.data.push(newObject);
		}
		this.suggestion.setSelectedIndex(-1);
		this.input.value = '';
		
		this.refreshList();
		
		if(firstNewKey != -1) {
			this.setSelectedIndex(firstNewKey);
		}
		
	}
	
	this.removeClick = function(event, index) {
		this.removeItem(index);
	}
	
	this.itemClick = function(event, index) {
		this.setSelectedIndex(index);
	}
	
	this.refreshList = function() {
		this.list.innerHTML = '';
		var ul = document.createElement('ul');
		this.list.appendChild(ul);

		for(var i=0;i<this.data.length;i++) {
			var item = this.data[i];
			var li = document.createElement('li');
			var removeLink = document.createElement('a');
			li.appendChild(removeLink);
			var removeImage = document.createElement('img');
			removeLink.appendChild(removeImage);

			var link = document.createElement('a')
			li.appendChild(link);
			var image = document.createElement('img');
			link.appendChild(image);
			var name = document.createTextNode(item.name);
			link.appendChild(name);
			
			removeLink.className = 'remove';
			
			if(this.selectedIndex == i) li.className = 'selected';
			li.id = this.name+'ListElement-'+i;
			image.src = RELATIVE_WCF_DIR+'icon/'+item.type+'S.png';
			
			removeImage.src = RELATIVE_WCF_DIR+'icon/deleteS.png';

			Event.observe(removeLink, 'click', this.removeClick.bindAsEventListener(this, i));
			Event.observe(link, 'click', this.itemClick.bindAsEventListener(this, i));
			ul.appendChild(li);
		}
	}
	
	this.setOption = function(option, value) {
		if(value == 1) {
			document.getElementById(option+'Yes').checked = true;
			document.getElementById(option+'No').checked = false;
		} else if(value == 0) {
			document.getElementById(option+'Yes').checked = false;
			document.getElementById(option+'No').checked = true;
		} else {
			document.getElementById(option+'Yes').checked = false;
			document.getElementById(option+'No').checked = false;
		}
	}
	
	this.getWhiteList = function() {
		var whiteList = document.getElementById('whiteList');
		var result = new Array;
		for(var i=0;i<whiteList.childNodes.length;i++) {
			var node = whiteList.childNodes[i];
			if(node.selected) {
				result.push(node.value);
			}
		}
		return result;
	}
	
	this.setWhiteList = function(values) {
		var whiteList = document.getElementById('whiteList');
		for(var i=0;i<whiteList.childNodes.length;i++) {
			var node = whiteList.childNodes[i];
			node.selected = (values.include(node.value) ? true : false);
		}
	}
	
	this.setSelectedIndex = function(index) {
		if(this.selectedIndex != -1) {
			var oldElement = document.getElementById(this.name+'ListElement-'+this.selectedIndex);
			if(oldElement != undefined) oldElement.className = '';
		}
		this.selectedIndex = index;
		
		if(this.selectedIndex != -1) {
			var item = this.data[this.selectedIndex];
			var element = document.getElementById(this.name+'ListElement-'+this.selectedIndex);
			element.className = 'selected';
			for(var i=0;i<this.options.length;i++) {
				this.setOption(this.options[i], item[this.options[i]]);
			}
			this.setWhiteList(item.whiteList);
			document.getElementById(this.name+'Title').innerHTML = item.name;
		} else {
			document.getElementById(this.name+'Title').innerHTML = '&nbsp;';
		}
	}
	
	this.refresh = function() {
		this.refreshList();
		this.setSelectedIndex(this.selectedIndex);
	}
	
	this.removeItem = function(index) {
		this.data.splice(index, 1);
		for(var i=0;i<this.options.length;i++) {
			this.setOption(this.options[i], -1);
		}
	
		this.refreshList();
		
		if(this.selectedIndex == index) {
			this.setSelectedIndex(-1);
		} else if(this.selectedIndex > index) {
			this.setSelectedIndex(this.selectedIndex - 1);
		}
	}
	
	this.createFormField = function(name, value) {
		var field = document.createElement('input');
		field.type = 'hidden';
		field.name = name;
		field.value = value;
		this.form.appendChild(field);
	}
	
	this.submit = function(event) {
		if(!event) event = window.event;
		
		if(this.inputHasFocus) event.stop();

		var fields = ['type','id','name','canView','canViewInformation','canViewBanner','canViewDataTransfer','canLogin'];
		for(var i=0;i<this.data.length;i++) {
			for(var j=0;j<fields.length;j++) {
				this.createFormField(this.name+'['+i+']['+fields[j]+']', this.data[i][fields[j]]);
			}
			this.createFormField(this.name+'['+i+'][whiteList]', this.data[i]['whiteList'].join(','));		
		}
		var result = this.formOldSubmit;
	}
}