<?php
// wcf imports
require_once(WCF_DIR.'lib/acp/form/TeamSpeakAddForm.class.php');
require_once(WCF_DIR.'lib/data/server/ServerFactory.class.php');

/**
 * Shows the server add form.
 * 
 * @author 	Sven Kutzner
 * @copyright	2010 deixu.net
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	net.deixu.wcf.teamspeak
 * @subpackage	acp.form
 * @category 	TeamSpeak Viewer
 */
class TeamSpeakEditForm extends TeamSpeakAddForm {
	// system
	public $activeMenuItem = 'wcf.acp.menu.link.content.teamspeak.list';
	public $neededPermissions = 'admin.teamspeak.canEditServer';
	public $action = 'edit';
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		if(isset($_GET['serverID'])) $this->serverID = intval($_GET['serverID']);
	}
	
	/**
	 * @see Form::save()
	 */
	public function save() {
		ACPForm::save();

		// save server
		if (WCF::getUser()->getPermission('admin.teamspeak.canEditServer')) {
			$server = new ServerEditor($this->serverID);
			$server->update($this->name, $this->version, $this->isEnabled, $this->statusBoxEnabled, $this->cacheTime, $this->serverPassword, $this->serverInformation,
				$this->sortOrder, $this->voiceHost, $this->voicePort, ($this->version == 3 ? $this->queryHost : $this->voiceHost), $this->queryPort,
				$this->fileHost, $this->filePort, $this->additionalFields);
			if (WCF::getUser()->getPermission('admin.teamspeak.canEditPermissions'))
				$server->updatePermissions($this->permissions);
			// reset cache
			$server->clearCache();
			$this->saved();
		}
		
		
		// reset values
		$this->version = 3;
		$this->sortOrder = 0;
		$this->isEnabled = $this->statusBoxEnabled = false;
		$this->name = $this->voiceHost = $this->queryHost = $this->fileHost = $this->serverPassword = '';
		$this->voicePort = 9987;
		$this->queryPort = 10011;
		$this->filePort = 30033;
		$this->permissions = array();
		
		// show success message
		WCF::getTPL()->assign(array(
			'success' => true
		));
	}
	
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		if($this->serverID == 0)
			throw new IllegalLinkException();
		$sql = 'SELECT * FROM wcf'.WCF_N.'_server WHERE serverID='.$this->serverID;
		if($data = WCF::getDB()->getFirstRow($sql)) {
			$this->version = $data['version'];
			$this->name = $data['name'];
			$this->cacheTime = $data['cacheTime'];
			$this->isEnabled = $data['isEnabled'];
			$this->statusBoxEnabled = $data['statusBoxEnabled'];
			$this->serverPassword = $data['serverPassword'];
			$this->serverInformation = $data['serverInformation'];
			$this->sortOrder = $data['sortOrder'];
			$this->voiceHost = $data['voiceHost'];
			$this->voicePort = $data['voicePort'];
			$this->queryHost = $data['queryHost'];
			$this->queryPort = $data['queryPort'];

			$permissionSQL = '(SELECT sg.groupID AS id, sg.*, g.groupName AS name, "group" AS permissionType
							FROM wcf'.WCF_N.'_server_to_group sg
							LEFT JOIN wcf'.WCF_N.'_group g ON (g.groupID=sg.groupID)
							WHERE serverID='.$this->serverID.')
							UNION ALL
							(SELECT su.userID AS id, su.*, u.username AS name, "user" AS permissionType
							FROM wcf'.WCF_N.'_server_to_user su
							LEFT JOIN wcf'.WCF_N.'_user u ON (u.userID=su.userID)
							WHERE serverID='.$this->serverID.')
							ORDER BY name';
			if($permissionResult = WCF::getDB()->sendQuery($permissionSQL)) {
				while($permissionData = WCF::getDB()->fetchArray($permissionResult)) {
					unset($permissionData['serverID']);
					if($permissionData['whiteList'] != "") {
						$permissionData['whiteList'] = explode(',', $permissionData['whiteList']);
					} else {
						$permissionData['whiteList'] = array(-1);
					} 
					$this->permissionList[] = $permissionData;
				}
			}
			
			try {
				$this->server = ServerFactory::getServer($this->serverID);
				$this->channels = $this->server->getChannels();
			}
			catch(Exception $e) {
				$this->channels = array();
			}
		}
	}	
}
?>