<?php
// wcf imports
require_once(WCF_DIR.'lib/page/AbstractPage.class.php');
require_once(WCF_DIR.'lib/data/server/ServerFactory.class.php');

/**
 * Shows a list of all TeamSpeak servers.
 * 
 * @author 	Sven Kutzner
 * @copyright	2010 deixu.net
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	net.deixu.wcf.teamspeak
 * @subpackage	acp.page
 * @category 	TeamSpeak Viewer
 */
class TeamSpeakListPage extends AbstractPage {
	// system
	public $templateName = 'teamSpeakList';
	
	/**
	 * structured list of boards
	 * 
	 * @var	array
	 */
	public $serverList = array();
	
	/**
	 * server id
	 * 
	 * @var	integer
	 */
	public $deletedServerID = 0;
	public $serverID = 0;
	
	/**
	 * If the list was sorted successfully
	 * @var boolean
	 */
	public $successfulSorting = false;
	
	/**
	 * If there was a successful action.
	 */
	public $success = '';
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		if (isset($_REQUEST['successfulSorting'])) $this->successfulSorting = true;
		if (isset($_REQUEST['deletedServerID'])) $this->deletedServerID = intval($_REQUEST['deletedServerID']);
		if (isset($_REQUEST['serverID'])) $this->serverID = intval($_REQUEST['serverID']);
		if (isset($_REQUEST['success'])) $this->success = StringUtil::trim($_REQUEST['success']);
	}
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		$this->renderServerList();
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign(array(
			'servers' => $this->serverList,
			'deletedServerID' => $this->deletedServerID,
			'serverID' => $this->serverID,
			'success' => $this->success,
			'successfulSorting' => $this->successfulSorting
		));
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		WCFACP::getMenu()->setActiveMenuItem('wcf.acp.menu.link.content.teamspeak.list');
		WCF::getUser()->checkPermission(array('admin.teamspeak.canEditServer', 'admin.teamspeak.canDeleteServer'));
		
		parent::show();
	}
	
	/**
	 * Renders the ordered list of all boards.
	 */
	protected function renderServerList() {
		$sql = 'SELECT * FROM wcf'.WCF_N.'_server ORDER BY sortOrder';
		if($serverResult = WCF::getDB()->sendQuery($sql)) {
			$maxPosition = WCF::getDB()->getAffectedRows();
			while($serverData = WCF::getDB()->fetchArray($serverResult)) {
				$serverData['maxPosition'] = $maxPosition;
				$this->serverList[$serverData['serverID']] = $serverData;
			}
		}
	}
	
}
