<?php

require_once(WCF_DIR.'lib/data/server/AbstractServer.class.php');

/**
 * A basic Server Editor for Server Objects.
 * 
 * @author	Sven Kutzner
 * @copyright	2010 deixu.net
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package net.deixu.wcf.teamspeak
 * @subpackage	data
 * @category 	TeamSpeak Viewer
 */
class ServerEditor extends AbstractServer {
	
	public function readData() {
		// do nothing
	}
	
	protected static function getServer($serverID) {
		$serverSQL = 'SELECT * FROM wcf'.WCF_N.'_server WHERE serverID='.$serverID;
		if($serverData = WCF::getDB()->getFirstRow($serverSQL)) {
			$groupSQL = 'SELECT * FROM wcf'.WCF_N.'_server_to_group WHERE serverID='.$serverID;
			if($groupResult = WCF::getDB()->sendQuery($groupSQL)) {
				if(WCF::getDB()->getAffectedRows($groupResult) > 0)
					$serverData['groupPermissions'] = array();
				while($groupData = WCF::getDB()->fetchArray($groupSQL)) {
					$serverData['groupPermissions'][$groupData['groupID']] = $groupData;
				}
			}
			$userSQL = 'SELECT * FROM wcf'.WCF_N.'_server_to_user WHERE serverID='.$serverID;
			if($userResult = WCF::getDB()->sendQuery($userSQL)) {
				if(WCF::getDB()->getAffectedRows($userResult) > 0)
					$serverData['userPermissions'] = array();
				while($userData = WCF::getDB()->fetchArray($userResult)) {
					$serverData['userPermissions'][$userData['userID']] = $userData;
				}
			}
			return $serverData;
		}
		return null;
	}
	
	public function __construct($serverID, $row = null, $cacheObject = null) {
		if(!is_null($serverID)) $row = self::getServer($serverID);
		parent::__construct($row, $cacheObject);
	}
	
	/**
	 * Updates the data of a server.
	 */
	public function update($name = null, $version = null, $isEnabled = null, $statusBoxEnabled = null, $cacheTime = null, $password = null, $information = null, $sortOrder = null, $voiceHost = null, $voicePort = null, $queryHost = null, $queryPort = null, $fileHost = null, $filePort = null, $additionalFields = null) {
		$fields = array();
		if ($name !== null) $fields['name'] = $name;
		if ($version !== null) $fields['version'] = $version;
		if ($isEnabled !== null) $fields['isEnabled'] = $isEnabled;
		if ($statusBoxEnabled !== null) $fields['statusBoxEnabled'] = $statusBoxEnabled;
		if ($cacheTime !== null) $fields['cacheTime'] = $cacheTime;
		if ($password !== null) $fields['serverPassword'] = $password;
		if ($information !== null) $fields['serverInformation'] = $information;
		if ($sortOrder !== null) $fields['sortOrder'] = $sortOrder;
		if ($voiceHost !== null) $fields['voiceHost'] = $voiceHost;
		if ($voicePort !== null) $fields['voicePort'] = $voicePort;
		if ($queryHost !== null) $fields['queryHost'] = $queryHost;
		if ($queryPort !== null) $fields['queryPort'] = $queryPort;
		if ($fileHost !== null) $fields['fileHost'] = $fileHost;
		if ($filePort !== null) $fields['filePort'] = $filePort;
		
		$this->updateData(array_merge($fields, $additionalFields));
	}
	
	/**
	 * Updates the data of a server.
	 *
	 * @param 	array		$fields
	 */
	public function updateData($fields = array()) { 
		$updates = '';
		foreach ($fields as $key => $value) {
			if (!empty($updates)) $updates .= ',';
			$updates .= $key.'=';
			if (is_int($value)) $updates .= $value;
			else $updates .= "'".escapeString($value)."'";
		}
		
		if (!empty($updates)) {
			$sql = 'UPDATE	wcf'.WCF_N.'_server
				SET	'.$updates.'
				WHERE	serverID='.$this->serverID;
			WCF::getDB()->sendQuery($sql);
		}
	}
	
	/**
	 * Creates a new server.
	 * 
	 * @return	ServerEditor
	 */
	public static function create($name, $version = 3, $isEnabled = 0, $statusBoxEnabled = 0, $cacheTime = 300, $password = '', $information = '', $sortOrder = 0, $voiceHost = '', $voicePort = 9987, $queryHost = '', $queryPort = 10011, $fileHost = '', $filePort = 30033, $additionalFields = array()) {
		// save data
		$serverID = self::insert($name, array_merge($additionalFields, array(
			'version' => $version,
			'isEnabled' => $isEnabled,
			'statusBoxEnabled' => $statusBoxEnabled,
			'cacheTime' => $cacheTime,
			'serverPassword' => $password,
			'serverInformation' => $information,
			'sortOrder' => $sortOrder,
			'voiceHost' => $voiceHost,
			'voicePort' => $voicePort,
			'queryHost' => $queryHost,
			'queryPort' => $queryPort,
			'fileHost' => $fileHost,
			'filePort' => $filePort
		)));
		
		// get server
		$server = new ServerEditor($serverID, null, null, false);
		
		// return new server
		return $server;
	}
	
	/**
	 * Creates the server row in database table.
	 *
	 * @param 	string 		$title
	 * @param 	array		$additionalFields
	 * @return	integer		new server id
	 */
	public static function insert($name, $additionalFields = array()) { 
		$keys = $values = '';
		foreach ($additionalFields as $key => $value) {
			$keys .= ','.$key;
			if (is_int($value)) $values .= ",".$value;
			else $values .= ",'".escapeString($value)."'";
		}
		
		$sql = 'INSERT INTO	wcf'.WCF_N.'_server
					(name
					'.$keys.')
			VALUES		("'.escapeString($name).'"
					'.$values.')';
		WCF::getDB()->sendQuery($sql);
		return WCF::getDB()->getInsertID();
	}
	
	/**
	 * Sets the isEnabled flag of a server.
	 *
	 * @param 	boolean 	$enable
	 */
	public function enable($enable = true) {
		$sql = 'UPDATE wcf'.WCF_N.'_server SET isEnabled='.($enable ? '1' : '0').' WHERE serverID='.$this->serverID;
		WCF::getDB()->sendQuery($sql);
	}
	
	/**
	 * Clears the cache of this server and of the server list.
	 */
	public function clearCache() {
		WCF::getCache()->addResource('server-'.$this->serverID, WCF_DIR.'cache/cache.server-'.$this->serverID.'.php', WCF_DIR.'lib/system/cache/CacheBuilderServer.class.php');
		WCF::getCache()->addResource('servers', WCF_DIR.'cache/cache.servers.php', WCF_DIR.'lib/system/cache/CacheBuilderServers.class.php');
		WCF::getCache()->clearResource('server-'.$this->serverID);
		WCF::getCache()->clearResource('servers');
	}
	
	public function delete() {
		$sql = 'DELETE FROM wcf'.WCF_N.'_server WHERE serverID='.$this->serverID;
		WCF::getDB()->sendQuery($sql);
		$sql = 'DELETE FROM wcf'.WCF_N.'_server_to_user WHERE serverID='.$this->serverID;
		WCF::getDB()->sendQuery($sql);
		$sql = 'DELETE FROM wcf'.WCF_N.'_server_to_group WHERE serverID='.$this->serverID;
		WCF::getDB()->sendQuery($sql);
		$this->clearCache();
	}
	
	public static function updatePosition($serverID, $position) {
		$sql = 'UPDATE wcf'.WCF_N.'_server SET sortOrder="'.$position.'" WHERE serverID="'.$serverID.'"';
		WCF::getDB()->sendQuery($sql);
	}
	
	public function updatePermissions($permissions) {
		$userPermissions = array();
		$groupPermissions = array();
		$userIDs = array();
		$groupIDs = array();
		
		foreach($permissions as $permission) {
			switch($permission['type']) {
				case 'user':
					$userPermissions[] = '('.$this->serverID.','.$permission['id'].','.$permission['canView'].','.$permission['canViewInformation'].','.$permission['canViewBanner'].','.$permission['canViewDataTransfer'].','.$permission['canLogin'].',"'.$permission['whiteList'].'")';
					$userIDs[] = $permission['id'];
					break;
				case 'group':
					$groupPermissions[] = '('.$this->serverID.','.$permission['id'].','.$permission['canView'].','.$permission['canViewInformation'].','.$permission['canViewBanner'].','.$permission['canViewDataTransfer'].','.$permission['canLogin'].',"'.$permission['whiteList'].'")';
					$groupIDs[] = $permission['id'];
					break;
			}
		}
		if(count($groupPermissions) > 0) {
			$insert = 'INSERT INTO wcf'.WCF_N.'_server_to_group (serverID, groupID, canView, canViewInformation, canViewBanner, canViewDataTransfer, canLogin, whiteList) VALUES ';
			$insert .= implode(',', $groupPermissions);
			$insert .= ' ON DUPLICATE KEY UPDATE canView=VALUES(canView),canViewInformation=VALUES(canViewInformation),canViewBanner=VALUES(canViewBanner),canViewDataTransfer=VALUES(canViewDataTransfer),canLogin=VALUES(canLogin),whiteList=VALUES(whiteList)';
			var_dump($insert);
			WCF::getDB()->sendQuery($insert);
			
			$delete = 'DELETE FROM wcf'.WCF_N.'_server_to_group WHERE serverID='.$this->serverID.' AND groupID NOT IN('.implode(',',$groupIDs).')';
			WCF::getDB()->sendQuery($delete);
		} else {
			$delete = 'DELETE FROM wcf'.WCF_N.'_server_to_group WHERE serverID='.$this->serverID;
			WCF::getDB()->sendQuery($delete);
		}
		
		if(count($userPermissions) > 0) {
			$insert = 'INSERT INTO wcf'.WCF_N.'_server_to_user (serverID, userID, canView, canViewInformation, canViewBanner, canViewDataTransfer, canLogin, whiteList) VALUES ';
			$insert .= implode(',', $userPermissions);
			$insert .= ' ON DUPLICATE KEY UPDATE canView=VALUES(canView),canViewInformation=VALUES(canViewInformation),canViewBanner=VALUES(canViewBanner),canViewDataTransfer=VALUES(canViewDataTransfer),canLogin=VALUES(canLogin),whiteList=VALUES(whiteList)';
			WCF::getDB()->sendQuery($delete);
			
			$delete = 'DELETE FROM wcf'.WCF_N.'_server_to_user WHERE serverID='.$this->serverID.' AND userID NOT IN('.implode(',',$userIDs).')';
			WCF::getDB()->sendQuery($insert);
		} else {
			$delete = 'DELETE FROM wcf'.WCF_N.'_server_to_user WHERE serverID='.$this->serverID;
			WCF::getDB()->sendQuery($delete);
		}
		
	}
}