<?php
// wcf imports
require_once(WCF_DIR.'lib/system/cache/CacheBuilder.class.php');

/**
 * Caches a server
 * 
 * @author	Sven Kutzner
 * @copyright	2010 deixu.net
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	net.deixu.wcf.teamspeak
 * @subpackage	system.cache
 * @category 	TeamSpeak Viewer
 */
class CacheBuilderServer implements CacheBuilder {
	protected static $serverClasses = array(2=>'TeamSpeak2Server',3=>'TeamSpeak3Server');
	protected static $additionalInfo = array(
		2=> array(
			'templateName'=>'teamSpeak2',
			'icon'=>'teamSpeak2',
			'style'=>'teamSpeak2'
			),
		3=> array(
			'templateName'=>'teamSpeak3',
			'icon'=>'teamSpeak3',
			'style'=>'teamSpeak3'
			)
		);
	
	/**
	 * @see CacheBuilder::getData()
	 */
	public function getData($cacheResource) {
		list($cache, $serverID) = explode('-', $cacheResource['cache']);
		$serverID = intval($serverID);
		
		$serverSQL = 'SELECT * FROM wcf'.WCF_N.'_server WHERE serverID='.$serverID;
		if($serverData = WCF::getDB()->getFirstRow($serverSQL)) {
			$groupSQL = 'SELECT * FROM wcf'.WCF_N.'_server_to_group WHERE serverID='.$serverID;
			$serverData['groupPermissions'] = array();
			if($groupResult = WCF::getDB()->sendQuery($groupSQL)) {
				while($groupData = WCF::getDB()->fetchArray($groupResult)) {
					$groupID = $groupData['groupID'];
					unset($groupData['serverID'], $groupData['groupID']);
					if($groupData['whiteList'] != "") {
						$groupData['whiteList'] = explode(',', $groupData['whiteList']);
					} else {
						$groupData['whiteList'] = array();
					} 
					$serverData['groupPermissions'][$groupID] = $groupData;
				}
			}
			$serverData['userPermissions'] = array();
			$userSQL = 'SELECT * FROM wcf'.WCF_N.'_server_to_user WHERE serverID='.$serverID;
			if($userResult = WCF::getDB()->sendQuery($userSQL)) {
				while($userData = WCF::getDB()->fetchArray($userResult)) {
					$userID = $userData['userID'];
					unset($userData['serverID'], $userData['userID']);
					if($userData['whiteList'] != "") {
						$userData['whiteList'] = explode(',', $userData['whiteList']);
					} else {
						$userData['whiteList'] = array();
					}
					$serverData['userPermissions'][$userID] = $userData;
				}
			}
			
			$serverData = array_merge($serverData, self::$additionalInfo[$serverData['version']]);
			
			$className = self::$serverClasses[$serverData['version']];
			require_once(WCF_DIR.'lib/data/server/'.$className.'.class.php');
			$server = new $className($serverData);
			try {
				$server->readData();
			} catch(Exception $e) {
				$server->setError($e);
			}
			
			return $server;
		}
	}
}