<?php
// wcf imports
require_once(WCF_DIR.'lib/system/cache/CacheBuilder.class.php');

/**
 * Caches a list of servers.
 * 
 * @author	Sven Kutzner
 * @copyright	2010 deixu.net
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	net.deixu.wcf.teamspeak
 * @subpackage	system.cache
 * @category 	TeamSpeak Viewer
 */
class CacheBuilderServers implements CacheBuilder {
	protected static $additionalInfo = array(
		2=> array(
			'templateName'=>'teamSpeak2',
			'icon'=>'teamSpeak2',
			'style'=>'teamSpeak2'
			),
		3=> array(
			'templateName'=>'teamSpeak3',
			'icon'=>'teamSpeak3',
			'style'=>'teamSpeak3'
			)
		);
	
	/**
	 * @see CacheBuilder::getData()
	 */
	public function getData($cacheResource) {
		$data = array();
		
		$serverSQL = 'SELECT * FROM wcf'.WCF_N.'_server WHERE isEnabled="1" ORDER BY sortOrder';
		if($serverResult = WCF::getDB()->sendQuery($serverSQL)) {
			while($serverData = WCF::getDB()->fetchArray($serverResult)) {
				$serverData = array_merge($serverData, self::$additionalInfo[$serverData['version']]);
				$data[$serverData['serverID']] = $serverData;
			}
		}
		return $data;
	}
}