<?php
// wcf imports
require_once(WCF_DIR.'lib/acp/form/ACPForm.class.php');
require_once(WCF_DIR.'lib/data/server/ServerEditor.class.php');
require_once(WCF_DIR.'lib/system/session/Session.class.php');

/**
 * Shows the server add form.
 * 
 * @author 	Sven Kutzner
 * @copyright	2010 deixu.net
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	net.deixu.wcf.teamspeak
 * @subpackage	acp.form
 * @category 	TeamSpeak Viewer
 */
class TeamSpeakAddForm extends ACPForm {
	// system
	public $templateName = 'teamSpeakAdd';
	public $activeMenuItem = 'wcf.acp.menu.link.content.teamspeak.add';
	public $neededPermissions = 'admin.teamspeak.canAddServer';
	public $activeTabMenuItem = 'data';
	public $action = 'add';
	
	public $channels = array();
	
	/**
	 * server editor object
	 * 
	 * @var	ServerEditor
	 */
	public $server;
	
	/**
	 * list of available permissions
	 * 
	 * @var	array
	 */
	public $permissionList = array();
	
	/**
	 * list of additional fields
	 * 
	 * @var	array
	 */
	public $additionalFields = array();
	
	// parameters
	public $serverID = 0;
	public $name = '';
	public $version = 3;
	public $isEnabled = false;
	public $statusBoxEnabled = false;
	public $serverPassword = '';
	public $serverInformation = '';
	public $cacheTime = 300;
	public $sortOrder = 0;
	public $voiceHost = '';
	public $voicePort = 9987;
	public $queryHost = '';
	public $queryPort = 10011;
	public $fileHost = '';
	public $filePort = 30033;
	public $permissions = array();
	
	/**
	 * @see Form::readFormParameters()
	 */
	public function readFormParameters() {
		parent::readFormParameters();
		
		// server configuration
		if (isset($_POST['serverID'])) $this->serverID = intval($_POST['serverID']);
		if (isset($_POST['name'])) $this->name = StringUtil::trim($_POST['name']);
		if (isset($_POST['version'])) $this->version = intval($_POST['version']);
		if (isset($_POST['isEnabled'])) $this->isEnabled = true;
		if (isset($_POST['statusBoxEnabled'])) $this->statusBoxEnabled = true;
		if (isset($_POST['serverPassword'])) $this->serverPassword = StringUtil::trim($_POST['serverPassword']);
		if (isset($_POST['serverInformation'])) $this->serverInformation = StringUtil::trim($_POST['serverInformation']);
		if (isset($_POST['cacheTime'])) $this->cacheTime = intval($_POST['cacheTime']);
		if (isset($_POST['sortOrder'])) $this->sortOrder = intval($_POST['sortOrder']);
		if (isset($_POST['voiceHost'])) $this->voiceHost = StringUtil::trim($_POST['voiceHost']);
		if (isset($_POST['voicePort'])) $this->voicePort = intval($_POST['voicePort']);
		if (isset($_POST['queryHost'])) $this->queryHost = StringUtil::trim($_POST['queryHost']);
		if (isset($_POST['queryPort'])) $this->queryPort = intval($_POST['queryPort']);
		if (isset($_POST['fileHost'])) $this->fileHost = StringUtil::trim($_POST['fileHost']);
		if (isset($_POST['filePort'])) $this->filePort = intval($_POST['filePort']);
		
		// permissions
		if (isset($_POST['permission']) && is_array($_POST['permission'])) $this->permissions = $_POST['permission'];
	}
	
	/**
	 * Validates the given permissions.
	 */
	public function validatePermissions() {
	}
	
	/**
	 * @see Form::validate()
	 */
	public function validate() {
		// validate permissions
		$this->validatePermissions();
		
		parent::validate();
		
		// version
		if ($this->version < 2 || $this->version > 3) {
			throw new UserInputException('version', 'invalid');
		}
		
		// name
		if (empty($this->name)) {
			throw new UserInputException('name');
		}

		// version
		if ($this->cacheTime <= 0) {
			throw new UserInputException('cacheTime', 'invalid');
		}
		
		// voice host
		if (empty($this->voiceHost)) {
			throw new UserInputException('voiceHost');
		}

		// voice port
		if (empty($this->voicePort)) {
			throw new UserInputException('voicePort');
		}

		// query host
		if ($this->version == 3 && empty($this->queryHost)) {
			throw new UserInputException('queryHost');
		}

		// query port
		if (empty($this->queryPort)) {
			throw new UserInputException('queryPort');
		}		
	}
	
	/**
	 * @see Form::save()
	 */
	public function save() {
		parent::save();
		// save server
		if (WCF::getUser()->getPermission('admin.teamspeak.canAddServer')) {
			$this->sortOrder = $this->getSortOrder();
			$this->server = ServerEditor::create($this->name, $this->version, $this->isEnabled, $this->statusBoxEnabled, $this->cacheTime, $this->serverPassword, $this->serverInformation, $this->sortOrder,
				$this->voiceHost, $this->voicePort, ($this->version == 3 ? $this->queryHost : $this->voiceHost), $this->queryPort, $this->fileHost, $this->filePort,
				$this->additionalFields);
			if (WCF::getUser()->getPermission('admin.teamspeak.canEditPermissions'))
				$this->server->updatePermissions($this->permissions);
		}
		
		// reset cache
		$this->server->clearCache();
		$this->saved();
		$this->server = null;
		
		// reset values
		$this->version = 3;
		$this->serverID = $this->sortOrder = 0;
		$this->isEnabled = $this->statusBoxEnabled = false;
		$this->name = $this->voiceHost = $this->queryHost = $this->fileHost = $this->serverPassword = '';
		$this->voicePort = 9987;
		$this->queryPort = 10011;
		$this->filePort = 30033;
		$this->permissions = array();
		
		// show success message
		WCF::getTPL()->assign(array(
			'success' => true
		));
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign(array(
			'serverID' => $this->serverID,
			'activeTabeMenuItem' => $this->activeTabMenuItem,
			'name' => $this->name,
			'version' => $this->version,
			'cacheTime' => $this->cacheTime,
			'isEnabled' => $this->isEnabled,
			'statusBoxEnabled' => $this->statusBoxEnabled,
			'serverPassword' => $this->serverPassword,
			'serverInformation' => $this->serverInformation,
			'sortOrder' => $this->sortOrder,
			'voiceHost' => $this->voiceHost,
			'voicePort' => $this->voicePort,
			'queryHost' => $this->queryHost,
			'queryPort' => $this->queryPort,
			'fileHost' => $this->fileHost,
			'filePort' => $this->filePort,
			'permissionList' => $this->permissionList,
			'server' => $this->server
		));
	}
	
	public function getSortOrder() {
		$sql = 'SELECT MAX(sortOrder)+1 AS sortOrder FROM wcf'.WCF_N.'_server';
		if($data = WCF::getDB()->getFirstRow($sql))
			return intval($data['sortOrder']);
		return 0;
	}
}
?>