<?php
require_once(WCF_DIR.'lib/page/AbstractPage.class.php');
require_once(WCF_DIR.'lib/page/util/menu/PageMenu.class.php');

require_once(WCF_DIR.'lib/data/server/ServerFactory.class.php');

/**
 * Shows a list of all TeamSpeak servers.
 * 
 * @author 	Sven Kutzner
 * @copyright	2010 deixu.net
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	net.deixu.wcf.teamspeak
 * @subpackage	frontend.page
 * @category 	TeamSpeak Viewer
 */
class TeamSpeakPage extends AbstractPage {
	protected static $serverClasses = array(2=>'TeamSpeak2Server',3=>'TeamSpeak3Server');
	protected static $additionalInfo = array(
		2=> array(
			'templateName'=>'teamSpeak2',
			'icon'=>'teamSpeak2',
			'style'=>'teamSpeak2'
			),
		3=> array(
			'templateName'=>'teamSpeak3',
			'icon'=>'teamSpeak3',
			'style'=>'teamSpeak3'
			)
		);
	
	public $templateName = 'teamSpeak';
	public $neededPermissions = 'user.teamspeak.canView';
	
	public $serverID;
	public $server;
	public $serverList;
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		if(isset($_GET['serverID'])) $this->serverID = intval($_GET['serverID']);
	}
	
	public function test($serverID) {
		$serverSQL = 'SELECT * FROM wcf'.WCF_N.'_server WHERE serverID='.$serverID;
		if($serverData = WCF::getDB()->getFirstRow($serverSQL)) {
			$groupSQL = 'SELECT * FROM wcf'.WCF_N.'_server_to_group WHERE serverID='.$serverID;
			$serverData['groupPermissions'] = array();
			if($groupResult = WCF::getDB()->sendQuery($groupSQL)) {
				while($groupData = WCF::getDB()->fetchArray($groupResult)) {
					$groupID = $groupData['groupID'];
					unset($groupData['serverID'], $groupData['groupID']);
					if($groupData['whiteList'] != "") {
						$groupData['whiteList'] = explode(',', $groupData['whiteList']);
					} else {
						$groupData['whiteList'] = array();
					} 
					$serverData['groupPermissions'][$groupID] = $groupData;
				}
			}
			$serverData['userPermissions'] = array();
			$userSQL = 'SELECT * FROM wcf'.WCF_N.'_server_to_user WHERE serverID='.$serverID;
			if($userResult = WCF::getDB()->sendQuery($userSQL)) {
				while($userData = WCF::getDB()->fetchArray($userResult)) {
					$userID = $userData['userID'];
					unset($userData['serverID'], $userData['userID']);
					if($userData['whiteList'] != "") {
						$userData['whiteList'] = explode(',', $userData['whiteList']);
					} else {
						$userData['whiteList'] = array();
					}
					$serverData['userPermissions'][$userID] = $userData;
				}
			}
			
			$serverData = array_merge($serverData, self::$additionalInfo[$serverData['version']]);
			
			$className = self::$serverClasses[$serverData['version']];
			require_once(WCF_DIR.'lib/data/server/'.$className.'.class.php');
			$server = new $className($serverData);
			$server->connect();
			try {
				$server->readData();
			} catch(Exception $e) {
				$server->setError($e);
			}
			return $server;
		}
	}
	
	
	public function readData() {
		$this->serverList = ServerFactory::getServerList();
		//$server = $this->test(2);
		if($this->serverID == null || !isset($this->serverList[$this->serverID])) {
			reset($this->serverList);
			$this->server = current($this->serverList);
			if($this->server instanceof AbstractServer) {
				$this->serverID = $this->server->serverID;
			}
		} else {
			$this->server = $this->serverList[$this->serverID];
		}
		parent::readData();
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		WCF::getTPL()->assign(array(
			'serverList'=> $this->serverList,
			'server' => $this->server
		));
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		// set active header menu item
		PageMenu::setActiveMenuItem('wcf.header.menu.teamspeak');
		
		parent::show();
	}
}
