CREATE TABLE wcf1_server (
  serverID int(11) NOT NULL auto_increment,
  version tinyint(4) NOT NULL DEFAULT '1',
  name varchar(255) NOT NULL DEFAULT 'TeamSpeak Server',
  isEnabled tinyint(4) NOT NULL DEFAULT '0',
  statusBoxEnabled tinyint(4) NOT NULL DEFAULT '0',
  cacheTime int(11) NOT NULL DEFAULT '300',
  serverPassword varchar(255) NOT NULL DEFAULT '',
  serverInformation text NOT NULL,
  sortOrder int(11) NOT NULL,
  voiceHost varchar(255) NOT NULL,
  voicePort int(11) NOT NULL DEFAULT '9987',
  queryHost varchar(255) NOT NULL,
  queryPort int(11) NOT NULL DEFAULT '10011',
  fileHost varchar(255) NOT NULL,
  filePort int(11) NOT NULL DEFAULT '30033',
  PRIMARY KEY  (serverID)
);
 
CREATE TABLE wcf1_server_to_group (
  serverID int(11) NOT NULL,
  groupID int(11) NOT NULL,
  canView tinyint(4) NOT NULL,
  canViewInformation tinyint(4) NOT NULL,
  canViewBanner tinyint(4) NOT NULL,
  canViewDataTransfer tinyint(4) NOT NULL,
  canLogin tinyint(4) NOT NULL,
  whiteList text NOT NULL,
  PRIMARY KEY  (serverID,groupID)
);

CREATE TABLE wcf1_server_to_user (
  serverID int(11) NOT NULL,
  userID int(11) NOT NULL,
  canView tinyint(4) NOT NULL,
  canViewInformation tinyint(4) NOT NULL,
  canViewBanner tinyint(4) NOT NULL,
  canViewDataTransfer tinyint(4) NOT NULL,
  canLogin tinyint(4) NOT NULL,
  whiteList text NOT NULL,
  PRIMARY KEY  (serverID,userID)
);
