{include file='header'}
<script type="text/javascript" src="{@RELATIVE_WCF_DIR}js/ItemListEditor.class.js"></script>
<script type="text/javascript">
	//<![CDATA[
	function init() {
		{if $servers|count > 0 && $this->user->getPermission('admin.teamspeak.canEditServer')}
			new ItemListEditor('serverList', { itemTitleEdit: false });
		{/if}
	}
	
	// when the dom is fully loaded, execute these scripts
	document.observe("dom:loaded", init);	
	
	//]]>
</script>

<div class="mainHeadline">
	<img src="{@RELATIVE_WCF_DIR}icon/teamSpeakL.png" alt="" />
	<div class="headlineContainer">
		<h2>{lang}wcf.acp.teamSpeakList.title{/lang}</h2>
		<h2>{lang}wcf.acp.teamSpeakList.description{/lang}</h2>
	</div>
</div>

{if $deletedServerID}
	<p class="success">{lang}wcf.acp.teamSpeakList.delete.success{/lang}</p>	
{/if}

{if $successfulSorting}
	<p class="success">{lang}wcf.acp.teamSpeakList.sort.success{/lang}</p>	
{/if}

{if $success == 'enableServer'}
<p class="success">{lang}wcf.acp.teamSpeakList.enable.success{/lang}</p>
{elseif $success == 'disableServer'}	
<p class="success">{lang}wcf.acp.teamSpeakList.disable.success{/lang}</p>
{/if}

{if $this->user->getPermission('admin.teamspeak.canAddServer')}
	<div class="contentHeader">
		<div class="largeButtons">
			<ul><li><a href="index.php?form=TeamSpeakAdd&amp;packageID={@PACKAGE_ID}{@SID_ARG_2ND}" title="{lang}wcf.acp.teamSpeakList.add{/lang}"><img src="{@RELATIVE_WCF_DIR}icon/teamSpeakAddM.png" alt="" /> <span>{lang}wcf.acp.teamSpeakList.add{/lang}</span></a></li></ul>
		</div>
	</div>
{/if}

{if $servers|count > 0}
	{if $this->user->getPermission('admin.teamspeak.canEditServer')}
	<form method="post" action="index.php?action=TeamSpeakSort">
	{/if}
		<div class="border content">
			<div class="container-1">
				<ol class="itemList" id="serverList">
					{foreach from=$servers item=server}
						<li id="item_{@$server.serverID}" class="deletable">
							<div class="buttons">
								{if $this->user->getPermission('admin.teamspeak.canEditServer')}
									<a href="index.php?form=TeamSpeakEdit&amp;serverID={@$server.serverID}&amp;packageID={@PACKAGE_ID}{@SID_ARG_2ND}"><img src="{@RELATIVE_WCF_DIR}icon/editS.png" alt="" title="{lang}wcf.acp.teamSpeakList.edit{/lang}" /></a>
								{else}
									<img src="{@RELATIVE_WCF_DIR}icon/editDisabledS.png" alt="" title="{lang}wcf.acp.teamSpeakList.edit{/lang}" />
								{/if}
								{if $this->user->getPermission('admin.teamspeak.canDeleteServer')}
									<a href="index.php?action=TeamSpeakDelete&amp;serverID={@$server.serverID}&amp;packageID={@PACKAGE_ID}{@SID_ARG_2ND}" title="{lang}wcf.acp.teamSpeakList.delete{/lang}" class="deleteButton"><img src="{@RELATIVE_WCF_DIR}icon/deleteS.png" alt="" longdesc="{lang}wcf.acp.teamSpeakList.delete.sure{/lang}"  /></a>
								{else}
									<img src="{@RELATIVE_WCF_DIR}icon/deleteDisabledS.png" alt="" title="{lang}wcf.acp.teamSpeakList.delete{/lang}" />
								{/if}
								
								{if $child.additionalButtons|isset}{@$child.additionalButtons}{/if}
							</div>
							
							<h3 class="itemListTitle">
								{if $this->user->getPermission('admin.teamspeak.canEditServer')}
									<select name="serverListPositions[{@$server.serverID}]">
										{section name='positions' loop=$server.maxPosition}
											<option value="{@$positions+1}"{if $positions+1 == $server.sortOrder} selected="selected"{/if}>{@$positions+1}</option>
										{/section}
									</select>
								{/if}
								ID-{@$server.serverID}
								{if $this->user->getPermission('admin.teamspeak.canEditServer')}
									<a href="index.php?action=TeamSpeak{if $server.isEnabled}Disable{else}Enable{/if}&amp;serverID={@$server.serverID}&amp;packageID={@PACKAGE_ID}{@SID_ARG_2ND}"><img src="{@RELATIVE_WCF_DIR}icon/{if $server.isEnabled}enabled{else}disabled{/if}S.png" alt="{if $server.isEnabled}{lang}wcf.acp.teamSpeakList.disable{/lang}{else}{lang}wcf.acp.teamSpeakList.enable{/lang}{/if}" title="{if $server.isEnabled}{lang}wcf.acp.teamSpeakList.disable{/lang}{else}{lang}wcf.acp.teamSpeakList.enable{/lang}{/if}" /></a>
								{else}
									<img src="{@RELATIVE_WCF_DIR}icon/{if $server.isEnabled}enabled{else}disabled{/if}DisabledS.png" alt="{if $server.isEnabled}{lang}wcf.acp.teamSpeakList.disable{/lang}{else}{lang}wcf.acp.teamSpeakList.enable{/lang}{/if}" title="{if $server.isEnabled}{lang}wcf.acp.teamSpeakList.disable{/lang}{else}{lang}wcf.acp.teamSpeakList.enable{/lang}{/if}" />
								{/if}
								<a href="index.php?form=TeamSpeakEdit&amp;serverID={@$server.serverID}&amp;packageID={@PACKAGE_ID}{@SID_ARG_2ND}" class="title">{lang}{$server.name}{/lang}</a>
							</h3>
					{/foreach}
				</ol>
			</div>
		</div>
	{if $this->user->getPermission('admin.teamspeak.canEditServer')}
		<div class="formSubmit">
			<input type="submit" accesskey="s" value="{lang}wcf.global.button.submit{/lang}" />
			<input type="reset" accesskey="r" id="reset" value="{lang}wcf.global.button.reset{/lang}" />
			<input type="hidden" name="packageID" value="{@PACKAGE_ID}" />
	 		{@SID_INPUT_TAG}
	 	</div>
	</form>
	{/if}
{else}
	<div class="border content">
		<div class="container-1">
			<p>{lang}wcf.acp.teamSpeakList.noServers{/lang}</p>
		</div>
	</div>
{/if}

{include file='footer'}