<?php
// wcf imports
require_once(WCF_DIR.'lib/acp/page/UserSuggestPage.class.php');

/**
 * Outputs an XML document with a list of suggested users and groups.
 *
 * @author	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	com.woltlab.wcf
 * @subpackage	acp.page
 * @category 	Community Framework
 */
class TeamSpeakUserGroupSuggestPage extends UserSuggestPage {
	/**
	 * @see Page::show()
	 */
	public function show() {
		AbstractPage::show();
				
		header('Content-type: text/xml');
		echo '<?xml version="1.0" encoding="'.CHARSET.'"?><suggestions query="'.escapeString($this->query).'">';
		
		if (!empty($this->query)) {
			// get suggestions
			$sql = '(SELECT		username AS name, "user" AS type, userID AS id
					FROM		wcf'.WCF_N.'_user
					WHERE		username LIKE "'.escapeString($this->query).'%")
					UNION ALL
					(SELECT		groupName AS name, "group" AS type, groupID AS id
					FROM		wcf'.WCF_N.'_group
					WHERE		groupName LIKE "'.escapeString($this->query).'%")
					ORDER BY	name';
			$result = WCF::getDB()->sendQuery($sql, 10);
			while ($row = WCF::getDB()->fetchArray($result)) {
				echo '<'.$row['type'].' id="'.$row['id'].'"><![CDATA['.StringUtil::escapeCDATA($row['name']).']]></'.$row['type'].'>';
			}
		}
		echo '</suggestions>';
		exit;
	}
}
?>