<?php

/**
 * ServerFactory class creates the Server objects.
 * 
 * @author	Sven Kutzner
 * @copyright	2010 deixu.net
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package net.deixu.wcf.teamspeak
 * @subpackage	data
 * @category 	TeamSpeak Viewer
 */
class ServerFactory {
	protected static $serverClasses = array(2=>'TeamSpeak2Server',3=>'TeamSpeak3Server');
	
	public static function getServer($serverID, $forceRebuild = false) {
		$sql = 'SELECT serverID, cacheTime, version FROM wcf'.WCF_N.'_server WHERE serverID='.$serverID;
		$data = WCF::getDB()->getFirstRow($sql);
		return self::createServer($data, $forceRebuild);
	}
	
	protected static function createServer($resultSet, $forceRebuild = false) {
		if(!is_array($resultSet)) throw new SystemException('Selected server does not exist.');
		$cacheTime = intval($resultSet['cacheTime']);

		$cacheResource = 'server-'.$resultSet['serverID'];
		$className = self::$serverClasses[$resultSet['version']];
		
		require_once(WCF_DIR.'lib/data/server/'.$className.'.class.php');
		
		WCF::getCache()->addResource($cacheResource, WCF_DIR.'cache/cache.'.$cacheResource.'.php', WCF_DIR.'lib/system/cache/CacheBuilderServer.class.php');
		if($forceRebuild) {
			WCF::getCache()->clearResource($cacheResource);
		}
		return WCF::getCache()->get($cacheResource);
	}
	
	public static function getServerList() {
		WCF::getCache()->addResource('servers', WCF_DIR.'cache/cache.servers.php', WCF_DIR.'lib/system/cache/CacheBuilderServers.class.php');
		//return WCF::getCache()->get('servers');
		$serverList = array();
		$servers = WCF::getCache()->get('servers');
		if(count($servers)) {
			foreach($servers as $server) {
				$serverList[$server['serverID']] = self::createServer($server);
			}
		}
		return $serverList;
	}
}