<?php
// wcf imports
require_once(WCF_DIR.'lib/data/cronjobs/Cronjob.class.php');

/**
 * Updates the TeamSpeak Viewer data
 * 
 * @author	Sven Kutzner
 * @copyright	2010 deixu.net
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	net.deixu.wcf.teamspeak
 * @subpackage	system.cronjob
 * @category 	TeamSpeak Viewer
 */
class TeamSpeakViewerUpdateCronjob implements Cronjob {
	protected static $serverClasses = array(2=>'TeamSpeak2Server',3=>'TeamSpeak3Server');
	
	protected function createServer($resultSet) {
		$forceRebuild = false;
		
		if(!is_array($resultSet)) throw new SystemException('Selected server does not exist.');
		$cacheTime = intval($resultSet['cacheTime']);
		if($cacheTime == 0)
			$forceRebuild = true;
		
		$cacheResource = 'server-'.$resultSet['serverID'];
		$className = self::$serverClasses[$resultSet['version']];
		
		require_once(WCF_DIR.'lib/data/server/'.$className.'.class.php');
		
		WCF::getCache()->addResource($cacheResource, WCF_DIR.'cache/cache.'.$cacheResource.'.php', WCF_DIR.'lib/system/cache/CacheBuilderServer.class.php', 0, $cacheTime);
		if($forceRebuild) {
			WCF::getCache()->clearResource($cacheResource);
		}
		$server = WCF::getCache()->get($cacheResource);
		unset($server);
	}
	
	/**
	 * @see Cronjob::execute()
	 */
	public function execute($data) {
		WCF::getCache()->addResource('servers', WCF_DIR.'cache/cache.servers.php', WCF_DIR.'lib/system/cache/CacheBuilderServers.class.php');
		$servers = WCF::getCache()->get('servers');
		if(count($servers)) {
			foreach($servers as $server) {
				$this->createServer($server);
			}
		}
		
	}
}
?>