<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
class TeamSpeakException extends Exception {
	protected $response;
	protected $information = '';
	protected $functions = '';

	/**
	 * Creates a new TeamSpeakException.
	 *
	 * @param	string		$message	error message
	 * @param	integer		$code		error code
	 * @param	string		$description	description of the error
	 */
	public function __construct($message = '', $code = 0, $response = array()) {
		parent::__construct($message, $code);
		$this->response = $response;
	}

	public function getResponse() {
		return $this->response;
	}

	public function getFailedPermissionID() {
		if(isset($this->response['error']['failed_permid'])) return intval($this->response['error']['failed_permid'], 0);
		return 0;
	}
        
	/**
	 * Removes database password from stack trace.
	 * @see Exception::getTraceAsString()
	 */
	public function __getTraceAsString() {
		$string = preg_replace('/Database->__construct\(.*\)/', 'Database->__construct(...)', $this->getTraceAsString());
		$string = preg_replace('/mysqli->mysqli\(.*\)/', 'mysqli->mysqli(...)', $string);
		return $string;
	}

}

?>