<?php
require_once(WCF_DIR.'lib/action/AbstractAction.class.php');
require_once(WCF_DIR.'lib/data/server/ServerEditor.class.php');

/**
 * Deletes a server.
 * 
 * @author	Sven Kutzner
 * @copyright	2010 deixu.net
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	net.deixu.wcf.teamspeak
 * @subpackage	acp.action
 * @category 	TeamSpeak Viewer
 */
class TeamSpeakDeleteAction extends AbstractAction {
	
	private $serverID = 0;

	/**
	 * @see Action::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		if(isset($_REQUEST['serverID'])) $this->serverID = intval($_REQUEST['serverID']);
	}
	
	/**
	 * @see Action::execute()
	 */
	public function execute() {
		parent::execute();
		// check permission
		WCF::getUser()->checkPermission('admin.teamspeak.canEditServer');

		$server = new ServerEditor($this->serverID);
		$server->delete();
		$this->executed();
		
		// forward to list page
		HeaderUtil::redirect('index.php?page=TeamSpeakList&success=deleteServer&serverID='.$this->serverID.'&packageID='.PACKAGE_ID.SID_ARG_2ND_NOT_ENCODED);
		exit;
	}
}
