<?php
// wcf imports
require_once(WCF_DIR.'lib/action/AbstractAction.class.php');
require_once(WCF_DIR.'lib/data/server/ServerEditor.class.php');

/**
 * Sorts the TeamSpeak servers.
 * 
 * @author	Sven Kutzner
 * @copyright	2010 deixu.net
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	net.deixu.wcf.teamspeak
 * @subpackage	acp.action
 * @category 	TeamSpeak Viewer
 */
class TeamSpeakSortAction extends AbstractAction {
	/**
	 * new positions
	 *
	 * @var array
	 */
	public $positions = array();
	
	/**
	 * @see Action::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		if (isset($_POST['serverListPositions']) && is_array($_POST['serverListPositions'])) $this->positions = ArrayUtil::toIntegerArray($_POST['serverListPositions']);
	}
	
	/**
	 * @see Action::execute()
	 */
	public function execute() {
		parent::execute();
		
		// check permission
		WCF::getUser()->checkPermission('admin.teamspeak.canEditServer');

		foreach ($this->positions as $serverID => $position) {
				ServerEditor::updatePosition(intval($serverID), $position);
		}
		
		// reset cache
		WCF::getCache()->addResource('servers', WCF_DIR.'cache/cache.servers.php', WCF_DIR.'lib/system/cache/CacheBuilderServers.class.php');
		WCF::getCache()->clearResource('servers');
		$this->executed();
		
		// forward to list page
		HeaderUtil::redirect('index.php?page=TeamSpeakList&successfulSorting=1&packageID='.PACKAGE_ID.SID_ARG_2ND_NOT_ENCODED);
		exit;
	}
}
?>